IF EXISTS (SELECT * FROM sys.objects 
				WHERE 
					object_id = OBJECT_ID(N'P_EST_PROD_AGENDA_COMPRA_PONTO_ENCOMENDA_DEMANDA') 
					AND type in (N'P', N'PC'))
begin
	DROP PROCEDURE P_EST_PROD_AGENDA_COMPRA_PONTO_ENCOMENDA_DEMANDA
end
GO
--  P_EST_PROD_AGENDA_COMPRA_PONTO_ENCOMENDA_DEMANDA 1,1 ,1,99
CREATE PROCEDURE P_EST_PROD_AGENDA_COMPRA_PONTO_ENCOMENDA_DEMANDA (@CD_EMP INT, @CD_USU INT, 
																	@CD_AGENDA INT, @CD_DEPOSITO INT) 

AS

set nocount on;
/***********************************************************************************************/

/***********************************************************************************************/
IF  OBJECT_ID('TEMPDB.DBO.#PontoProdutos') IS NOT NULL
BEGIN
	DROP TABLE #PontoProdutos
END

create table #PontoProdutos(cd_emp Tinyint, cd_prod int); 

INSERT INTO #PontoProdutos
SELECT 
	CD_EMP,
	CD_PROD 
FROM 
	dbo.UFD_EST_PROD_AGENDA_COMPRA_PRODUTOS(1,@CD_AGENDA);

/***********************************************************************************************/
IF  OBJECT_ID('TEMPDB.DBO.#PontoAgenda') IS NOT NULL
BEGIN
	DROP TABLE #PontoAgenda
END
create table #PontoAgenda  (cd_emp Tinyint, CD_AGENDA int, 
								LEAD_TIME INT, DT_AGENDAMENTO DATE, 
								PARAM_EST INT, FREQ_REV INT);
	INSERT INTO #PontoAgenda  
	SELECT 
		A.CD_EMP, 
		B.CD_AGENDA,
		A.LEAD_TIME, 
		B.DT_AGENDA DT_AGENDAMENTO,
		A.PARAM_EST,
		A.FREQ_REV
	FROM 
		EST_PROD_AGENDA_COMPRA A
		JOIN EST_PROD_AGENDA_COMPRA_AGENDAMENTO B ON 
		A.CD_CTR_AGENDA = B.CD_CTR_AGENDA
	WHERE
		A.CD_EMP=@CD_EMP 
		AND B.CD_AGENDA=@CD_AGENDA ; 
	
/***********************************************************************************************/
IF  OBJECT_ID('TEMPDB.DBO.#Pontofilial') IS NOT NULL
BEGIN
	DROP TABLE #Pontofilial
END
CREATE TABLE #Pontofilial (CD_EMP INT, CD_FILIAL INT, CD_AGENDA INT )

	INSERT INTO #Pontofilial
	select 
		F.CD_EMP,
		F.CD_FILIAL,
		TA.CD_AGENDA
	from 
		EST_PROD_AGENDA_COMPRA A
		JOIN EST_PROD_AGENDA_COMPRA_PRC_BANDEIRA B ON
		A.CD_CTR_AGENDA =B.CD_CTR_AGENDA
		JOIN PRC_BANDEIRA_PRC_FILIAL F ON
		B.CD_BANDEIRA = F.CD_BANDEIRA 
		JOIN #PontoAgenda TA ON 
		A.CD_CTR_AGENDA = TA.CD_AGENDA ;

	INSERT INTO #Pontofilial
	SELECT 
		F.CD_EMP,
		F.CD_FILIAL,
		TA.CD_AGENDA
	FROM 
		EST_PROD_AGENDA_COMPRA A
		JOIN EST_PROD_AGENDA_COMPRA_PRC_FILIAL F ON
		A.CD_CTR_AGENDA =F.CD_CTR_AGENDA 
		JOIN #PontoAgenda TA ON 
		A.CD_CTR_AGENDA = TA.CD_AGENDA  
		LEFT JOIN #Pontofilial T ON 
		F.CD_FILIAL  = T.CD_FILIAL 
	WHERE
		T.CD_FILIAL IS NULL  ;
		  
--Print 'Carregou as filiais da agenda - Time ' + convert(varchar, getdate(),108);		


/***********************************************************************************************/
IF  OBJECT_ID('TEMPDB.DBO.#PontoDemanda') IS NOT NULL
BEGIN
	DROP TABLE #PontoDemanda
END
create table #PontoDemanda  (	CD_PROD INT
							,VLR_CUSTO     MONEY        
							,PERC_DESC     MONEY        
							,QT_EST           MONEY     
							,MEDIAF           MONEY     
							,QT_PEND_ENT      MONEY     
							,QT_EST_LJS       MONEY 
							,QEMAX			  MONEY
							,EMAX			  MONEY    
							,SUGESTAO		  MONEY
							,CD_SIGLA			TINYINT
							,VLR_TABELA			MONEY)


insert into #PontoDemanda 
SELECT 
	   C.CD_PROD
	 , (CASE WHEN ISNULL(C.VLR_FABRICA, 0) > 0 THEN 
				ISNULL(C.VLR_FABRICA, 0)
			ELSE C.VLR_COMPRA_GRP
		END) VLR_CUSTO
	 , ISNULL(C.PERC_DESC_FABRICA, 0) PERC_DESC
	 , (C.QT_EST + C.QT_EST_EM_TERC) QT_EST
	 , LJ.MEDIAF
	 , C.QT_PEND_ENT
	 , LJ.QT_EST_LJS
	 , ROUND((LJ.MEDIAF/30.000) * (A.PARAM_EST+ A.LEAD_TIME),0) QMAX
	 ,(A.PARAM_EST+ A.LEAD_TIME) EMAX

	 , CONVERT( MONEY, ROUND(LJ.MEDIAF * (((A.PARAM_EST - (28. / A.FREQ_REV) + 	(DATEDIFF(D, (GETDATE()), A.DT_AGENDAMENTO))) + A.LEAD_TIME 
	 			- (CASE WHEN LJ.MEDIAF > 0 THEN ROUND((((C.QT_EST_EM_TERC + C.QT_EST + C.QT_PEND_ENT) / (LJ.MEDIAF)) * 30), 0)
					ELSE ROUND((((C.QT_EST_EM_TERC + C.QT_EST + C.QT_PEND_ENT) / (0.0001)) * 30), 0)
					END)) / 30.0), 0)
				) SUGESTAO
	, C.CD_SIGLA
	, E.VLR_TABELA

FROM 
	 V_EST_PROD_CPL_ESTOQUE_PEDIDO C
	 INNER JOIN EST_PROD_PRECO E ON 
	 C.CD_EMP		= E.CD_EMP AND
	 C.CD_FILIAL	= E.CD_FILIAL AND
	 C.CD_PROD		= E.CD_PROD


	 INNER JOIN #PontoAgenda A ON 
	 C.CD_EMP = A.CD_EMP

	 INNER JOIN(SELECT E.CD_EMP
						 , E.CD_PROD
						 , SUM(E.QT_EST) QT_EST_LJS
						 , SUM(E.MEDIAF) MEDIAF 
					FROM 
						V_EST_PROD_CPL_ESTOQUE_PEDIDO  E
						JOIN #Pontofilial A ON 
						E.CD_EMP = A.CD_EMP AND
						E.CD_FILIAL = A.CD_FILIAL

						JOIN #PontoProdutos b ON 
						E.CD_EMP = b.CD_EMP AND
						E.CD_PROD = b.CD_PROD

					WHERE 
						E.CD_EMP=@CD_EMP
						AND E.CD_FILIAL <> (@CD_DEPOSITO)
					GROUP BY E.CD_EMP, E.CD_PROD ) LJ ON 							
	C.CD_EMP	= LJ.CD_EMP AND 
	C.CD_PROD	= LJ.CD_PROD

WHERE 
	C.CD_EMP = 1
	AND C.COMPRA_POR_SUPRIMENTO IN(1, 2)
	AND C.CD_FILIAL = @CD_DEPOSITO 
	AND C.STS_PROD = 0
	AND C.STS_PROD_FILIAL = 0
	AND DATEDIFF(D, (GETDATE()), (DATEADD(D, a.LEAD_TIME, a.DT_AGENDAMENTO))) > 
																			CASE WHEN LJ.MEDIAF > 0 THEN 
																				ROUND((((C.QT_EST_EM_TERC + C.QT_EST + C.QT_PEND_ENT) / (LJ.MEDIAF)) * 30), 0)
																			ELSE ROUND((((C.QT_EST_EM_TERC + C.QT_EST + C.QT_PEND_ENT) / (0.0001)) * 30), 0) END
	AND a.DT_AGENDAMENTO > GETDATE()
	AND (ROUND(LJ.MEDIAF * (((a.PARAM_EST - (28. / a.FREQ_REV) + (DATEDIFF(D, (GETDATE()), a.DT_AGENDAMENTO))) + a.LEAD_TIME - (CASE  WHEN LJ.MEDIAF > 0 THEN ROUND((((C.QT_EST_EM_TERC + C.QT_EST + C.QT_PEND_ENT) / (LJ.MEDIAF)) * 30), 0)
																																		ELSE ROUND((((C.QT_EST_EM_TERC + C.QT_EST + C.QT_PEND_ENT) / (0.0001)) * 30), 0)
																																	END)) / 30.0), 0)) > 0

	

/**************************************************************************/
/* Dados de vendas	    												  */
/**************************************************************************/

print 'Calculando a venda dos produtos ' + convert(varchar(10),getdate(),108);
IF  OBJECT_ID('TEMPDB.DBO.#PontoVenda') IS NOT NULL
BEGIN
	DROP TABLE #TMP_VENDA
END

IF  OBJECT_ID('TEMPDB.DBO.#TBL_BASE') IS NOT NULL
BEGIN
	DROP TABLE #TBL_BASE 
END
CREATE TABLE #TBL_BASE ( CD_EMP		tinyint, 
						CD_PROD		INT,
						ANO_MES		VARCHAR(15),
						QT_IT		INT);

CREATE TABLE #PontoVenda(CD_EMP		tinyint, 
								CD_PROD		int,
								DT_ULT_VD		date,
								QT_VD_MES		money,
								QT_VD_MES1		money,
								QT_VD_MES2		money,
								QT_VD_MES3		money)

/*************************************************************************************************/
 
	DECLARE @DT_INI DATE,
			@DT_FIM DATE, 
			@ANO_MES1 INT, 
			@ANO_MES2 INT, 
			@ANO_MES3 INT;

	SELECT	@DT_FIM = DATEADD(day,-1,getdate()),  --Dia anterior
			@DT_INI = DATEADD(day, -29, @DT_FIM), --1 ms e 1 dia atrs
			@ANO_MES1 = CONVERT(CHAR(6), DATEADD(MONTH,-1,@DT_FIM), 112), --ms anterior
			@ANO_MES2 = CONVERT(CHAR(6), DATEADD(MONTH,-2,@DT_FIM), 112), --2 meses atrs
			@ANO_MES3 = CONVERT(CHAR(6), DATEADD(MONTH,-3,@DT_FIM), 112); --3 meses atrs
 	
	INSERT INTO #TBL_BASE
	SELECT
		@CD_EMP AS CD_EMP, 
		i.CD_PROD, 
		'QT_IT_ATUAL' AS ANO_MES,
		SUM(I.QT_VD)	AS QT_IT
	FROM 
		EST_PROD_CPL_VD		I
		INNER JOIN #PontoProdutos arv on 
		I.CD_EMP		= arv.CD_EMP AND 
		I.CD_PROD		= arv.CD_PROD
		 
		INNER JOIN #Pontofilial f on 
		I.CD_EMP		= f.CD_EMP AND 
		I.CD_FILIAL	= f.CD_FILIAL 

	WHERE	
		I.CD_EMP = @CD_EMP      
		AND I.ANO = YEAR(GETDATE())
		AND I.MES = MONTH(GETDATE())
	GROUP BY i.CD_PROD
		
	PRINT 'Carregou venda ultimos 30 dias ' + convert(varchar,getdate(), 108);

	INSERT INTO #TBL_BASE
	SELECT 
		@CD_EMP AS CD_EMP,  
		mov.CD_PROD, 
		CASE mov.ANO_MES	WHEN @ANO_MES1 THEN 'QT_IT_MES1' 
							WHEN @ANO_MES2 THEN 'QT_IT_MES2'
							WHEN @ANO_MES3 THEN 'QT_IT_MES3' END,
		SUM(MOV.QT_VD) AS QT_IT
	FROM         
		EST_PROD_CPL_VD mov  
		INNER JOIN #PontoVenda arv on 
		mov.CD_EMP		= arv.CD_EMP AND  
		mov.CD_PROD		= arv.CD_PROD 
				 
		INNER JOIN #Pontofilial f on 
		mov.CD_EMP		= f.CD_EMP AND 
		mov.CD_FILIAL	= f.CD_FILIAL 
	WHERE     
		mov.ANO_MES BETWEEN @ANO_MES3 AND @ANO_MES1
		AND mov.CD_EMP = @CD_EMP
	GROUP BY mov.CD_PROD, mov.ANO_MES	;
		
	PRINT 'Carregou venda ultimos 3 meses' + convert(varchar,getdate(), 108);

	INSERT INTO #PontoVenda (CD_EMP, CD_PROD, DT_ULT_VD,QT_VD_MES, QT_VD_MES1, QT_VD_MES2, QT_VD_MES3)
	SELECT
		@CD_EMP, 
		I.CD_PROD,
		max(VV.DT_CAD ) DT_ULT_VD,
		SUM(ISNULL(mov.QT_IT_ATUAL,0)) QT_VD_MES,
		SUM(ISNULL(mov.QT_VD_MES1,0)) QT_VD_MES1,
		SUM(ISNULL(mov.QT_VD_MES2,0)) QT_VD_MES2,
		SUM(ISNULL(mov.QT_VD_MES3,0)) QT_VD_MES3 
	FROM
		#PontoDemanda  I 
		LEFT JOIN (SELECT	CD_EMP, 
								CD_PROD, 
								ISNULL([QT_IT_ATUAL], 0) AS QT_IT_ATUAL, 
								ISNULL([QT_IT_MES1], 0) AS QT_VD_MES1, 
								ISNULL([QT_IT_MES2], 0) AS QT_VD_MES2, 
								ISNULL([QT_IT_MES3], 0) AS QT_VD_MES3
					FROM #TBL_BASE PIVOT (SUM(QT_IT) 
						FOR ANO_MES IN ([QT_IT_ATUAL], [QT_IT_MES1], [QT_IT_MES2], [QT_IT_MES3])) AS pvt
					) MOV ON
		@CD_EMP	= mov.CD_EMP AND    
		I.CD_PROD	= mov.CD_PROD  
			
		LEFT JOIN EST_PROD_CPL_ULT_MOV_PDV_VD VV ON    
		@CD_EMP	= VV.CD_EMP AND    
		I.CD_PROD	= VV.CD_PROD
	group by  
		I.CD_PROD;
		 
	PRINT 'Carregou as informacoes de venda' + convert(varchar,getdate(), 108);
	CREATE UNIQUE CLUSTERED INDEX #ix_tmp_venda ON #pontoVenda (CD_PROD,CD_EMP);		

/**************************************************************************/
/**************************************************************************/
	DELETE FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA
	WHERE
		CD_USU=@CD_USU;
 
	INSERT INTO EST_PROD_SUPRIMENTO_ENTREGA_LOJA (CD_EMP,CD_FILIAL,CD_PROD,
													CD_USU,QTDE_SUGESTAO,
													QTDE_NECESSIDADE,QTDE_ESTOQUE,
													QTDE_PAR_FACE_FINAN_EMAX,QTDE_LIMITADOR,CONSIDERA_EST_CD,
													CD_COND_COMPRA,QTDE_PROD,VLR_PROD,PERC_DESC,CD_SIGLA,
													MEDIAF,QT_EST,QT_EST_PEND,QT_EST_MTZ,
													MAX_EMAX,EMAX,ESEG,FACE,FINA,LIMITADOR,QT_PEND_ENT, 
													VLR_TABELA, DT_ULT_VD, QT_VD_MES,QT_VD_MES1,
													QT_VD_MES2,QT_VD_MES3,DT_CAD,QTDE_PROD_ORIGINAL)
	SELECT
		@CD_EMP,
		@CD_DEPOSITO CD_FILIAL,
		I.CD_PROD,
		@CD_USU, 
		ROUND(isnull(I.SUGESTAO,0),0) SUGESTAO,
		0 NECESSIDADE, 
		isnull(I.QT_EST,0),
		isnull(I.QEMAX,0),
		0 QTDE_LIMITADOR,
		1 CONSIDERA_EST_CD,
		0 CD_COND_COMPRA,
		ROUND(isnull(I.SUGESTAO,0),0) QTDE_PROD,
		ISNULL(I.VLR_CUSTO,0) VLR_PROD, 
		ISNULL(i.PERC_DESC,0) PERC_DESC, 

		i.CD_SIGLA,
		i.MEDIAF,
		i.QT_EST QT_EST_REAL,
		i.QT_PEND_ENT QT_EST_PEND,
		i.QT_EST QT_EST_MTZ,
		i.QEMAX,
		i.EMAX,
		0 ESEG,
		0 FACE,
		0 FINA,
		0 LIMITADOR,
		i.QT_PEND_ENT,
		i.VLR_TABELA,
		V.DT_ULT_VD, 
		ISNULL(V.QT_VD_MES,0) QT_VD_MES,
		ISNULL(V.QT_VD_MES1,0) QT_VD_MES1,
		ISNULL(V.QT_VD_MES2,0) QT_VD_MES2,
		ISNULL(V.QT_VD_MES3,0) QT_VD_MES3,
		GETDATE(),
		ROUND(isnull(I.SUGESTAO,0),0)  QTDE_PROD_ORIGINAL
	FROM
		#PontoDemanda  I 
		LEFT JOIN #pontoVenda V ON  
		I.CD_PROD	= V.CD_PROD  
 